const ACTIONS = {
    "summarize": "Summarize",
    "fix_grammar": "Fix Grammar",
    "explain_simple": "Explain Simpler",
    "rewrite_level_child": "Rewrite for Child",
    "rewrite_level_general": "Rewrite General",
    "rewrite_level_expert": "Rewrite Expert",
    "tone_professional": "Tone: Professional",
    "tone_friendly": "Tone: Friendly",
    "analyze_credibility": "Check Credibility",
    "analyze_bias": "Check Bias",
    "analyze_claims": "Find Claims (Citations)",
    "seo_meta": "SEO: Meta Description",
    "seo_keywords": "SEO: Keywords",
    "seo_intent": "SEO: Search Intent"
};

chrome.runtime.onInstalled.addListener(() => {
    // 1. Create Main Parent
    chrome.contextMenus.create({
        id: "axiom_parent",
        title: "AxiomAI",
        contexts: ["selection", "page", "editable"]
    });

    // 2. High-Level Utilities (Directly under Parent)
    const utilities = ["summarize", "fix_grammar", "explain_simple"];
    utilities.forEach(id => {
        chrome.contextMenus.create({
            id: id,
            parentId: "axiom_parent",
            title: ACTIONS[id],
            contexts: ["selection", "page", "editable"]
        });
    });

    // 3. Separator
    chrome.contextMenus.create({
        id: "sep_1",
        parentId: "axiom_parent",
        type: "separator",
        contexts: ["selection", "page", "editable"]
    });

    // 4. Submenu: Rewrite
    chrome.contextMenus.create({
        id: "submenu_rewrite",
        parentId: "axiom_parent",
        title: "Rewrite...",
        contexts: ["selection", "page", "editable"]
    });
    // Rewrite Options
    const rewrites = ["rewrite_level_child", "rewrite_level_general", "rewrite_level_expert", "tone_professional", "tone_friendly"];
    rewrites.forEach(id => {
        chrome.contextMenus.create({
            id: id,
            parentId: "submenu_rewrite",
            title: ACTIONS[id],
            contexts: ["selection", "page", "editable"]
        });
    });

    // 5. Submenu: Analyze
    chrome.contextMenus.create({
        id: "submenu_analyze",
        parentId: "axiom_parent",
        title: "Analyze...",
        contexts: ["selection", "page", "editable"]
    });
    // Analyze Options
    const analyze = ["analyze_credibility", "analyze_bias", "analyze_claims"];
    analyze.forEach(id => {
        chrome.contextMenus.create({
            id: id,
            parentId: "submenu_analyze",
            title: ACTIONS[id],
            contexts: ["selection", "page", "editable"]
        });
    });

    // 6. Submenu: SEO
    chrome.contextMenus.create({
        id: "submenu_seo",
        parentId: "axiom_parent",
        title: "SEO Tools...",
        contexts: ["selection", "page", "editable"]
    });
    // SEO Options
    const seo = ["seo_meta", "seo_keywords", "seo_intent"];
    seo.forEach(id => {
        chrome.contextMenus.create({
            id: id,
            parentId: "submenu_seo",
            title: ACTIONS[id],
            contexts: ["selection", "page", "editable"]
        });
    });
});

chrome.contextMenus.onClicked.addListener((info, tab) => {
    if (info.menuItemId && ACTIONS[info.menuItemId]) {
        // Send message to content script
        // We rely on content script to figure out "what text" if selection is empty but right-clicked something.
        // However, chrome.contextMenus gives us info.selectionText.
        chrome.tabs.sendMessage(tab.id, {
            type: "AXIOM_ACTION",
            action: info.menuItemId,
            selectionText: info.selectionText, // Fallback if content script selection is weird
            pageUrl: tab.url,
            pageTitle: tab.title
        }).catch(err => {
            // Content script might not be loaded (e.g. restring settings page)
            console.warn("Could not send message to tab", err);
        });
    }
});
