const defaultUrl = "https://api.axiomai.dev/rewrite";

// Saves options to chrome.storage
const saveOptions = () => {
    const immediateReplace = document.getElementById('immediateReplace').checked;
    const selectionOnly = document.getElementById('selectionOnly').checked;

    chrome.storage.sync.set(
        { immediateReplace, selectionOnly },
        () => {
            const status = document.getElementById('status');
            status.textContent = 'Options saved.';
            setTimeout(() => {
                status.textContent = '';
            }, 750);
        }
    );
};

// Restores select box and checkbox state using the preferences
// stored in chrome.storage.
const restoreOptions = () => {
    chrome.storage.sync.get(
        { immediateReplace: false, selectionOnly: false },
        (items) => {
            document.getElementById('immediateReplace').checked = items.immediateReplace;
            document.getElementById('selectionOnly').checked = items.selectionOnly;
        }
    );
};

document.addEventListener('DOMContentLoaded', restoreOptions);
document.getElementById('saveBtn').addEventListener('click', saveOptions);
